




capture drop Q1relApp
capture drop Q1relApp
capture drop Q2relApp
capture drop Q3relApp
capture drop Q4relApp

generate Q1relApp=hypo_q1/homevalue
generate Q2relApp=hypo_q2/homevalue
generate Q3relApp=hypo_q3/homevalue
generate Q4relApp=hypo_q4/homevalue

capture drop phi_from_Q4
generate phi_from_Q4=hypo_q4/homevalue-1


*Finds the 2D heterogeneirty for the simple example of user cost model
capture program drop nlsolver
program nlsolver, rclass


		syntax varlist(min=1 max=1) [if], at(name)
		
		tempname	phi  rho
		scalar `phi' = `at'[1,1]
		scalar `rho' = `at'[1,2]
		
		tempvar yh
        gen double `yh' = (1+`phi')/(tightDP*`rho'+(1-tightDP)*rate1)-WTP1 +1 in 1
        replace `yh' = (1+`phi')/(looseDP*`rho'+(1-looseDP)*rate1)-WTP2 in 2
        

        replace `varlist' = `yh'

 end
 
 
 *Finds rho conditional on phi from Q4 using Q1 and Q2
 capture program drop nlsolver_Q124
program nlsolver_Q124, rclass


		syntax varlist(min=1 max=1) [if], at(name)
		
		tempname	  rho
		scalar `rho' = `at'[1,1]
		
		tempvar yh
       
	  * gen double `yh' = (1+phiQ4)/(tightDP*`rho'+(1-tightDP)*rate1)-WTP1 +1 in 1
      *  replace `yh' = (1+phiQ4)/(looseDP*`rho'+(1-looseDP)*rate1)-WTP2 in 2
        
			gen double `yh' = (1+phiQ4)/(tightDP*`rho'+(1-tightDP)*rate1*(1-margtax) + propertytax ///
		- growth + growth*(1-tightDP)*(1-mobility)*((`rho'-(1-margtax)*rate1)/(`rho'+mobility)))-WTP1 +1 in 1
			
        replace `yh' = (1+phiQ4)/(looseDP*`rho'+(1-looseDP)*rate1*(1-margtax)+propertytax ///
		- growth+growth*(1-looseDP)*(1-mobility)*((`rho'-(1-margtax)*rate1)/(`rho'+mobility)))-WTP2 in 2
		

        replace `varlist' = `yh'

 end
 
 *Finds rho conditional on phi from Q4 using Q1
 capture program drop nlsolver_Q14
program nlsolver_Q14, rclass


		syntax varlist(min=1 max=1) [if], at(name)
		
		tempname	  rho
		scalar `rho' = `at'[1,1]
		
		tempvar yh
       
	 *  gen double `yh' = (1+phiQ4)/(tightDP*`rho'+(1-tightDP)*rate1)-WTP1 +1 in 1
    *    replace `yh' = (1+phiQ4)/(tightDP*`rho'+(1-tightDP)*rate1)-WTP1 in 2
		
		gen double `yh' = (1+phiQ4)/(tightDP*`rho'+(1-tightDP)*rate1*(1-margtax) + propertytax ///
		- growth + growth*(1-tightDP)*(1-mobility)*((`rho'-(1-margtax)*rate1)/(`rho'+mobility)))-WTP1 +1 in 1
			
        replace `yh' =  (1+phiQ4)/(tightDP*`rho'+(1-tightDP)*rate1*(1-margtax) + propertytax ///
		- growth + growth*(1-tightDP)*(1-mobility)*((`rho'-(1-margtax)*rate1)/(`rho'+mobility)))-WTP1 in 2
        

        replace `varlist' = `yh'

 end
 
 *Use more variables -- not used
 
 capture program drop nlsolverplus
program nlsolverplus, rclass


		syntax varlist(min=1 max=1) [if], at(name)
		
		tempname	phi  rho
		scalar `phi' = `at'[1,1]
		scalar `rho' = `at'[1,2]
		
		tempvar yh
		
       gen double `yh' = (1+`phi')/(tightDP*`rho'+(1-tightDP)*rate1)-WTP1 +1 in 1
      replace `yh' = (1+`phi')/(looseDP*`rho'+(1-looseDP)*rate1)-WTP2 in 2
		replace `yh' = (1+`phi')/(looseDP*`rho'+(1-looseDP)*rate2)-WTP3 in 3
		replace `yh' = (1+`phi')/(looseDP*rate2+(1-looseDP)*rate2)-WTP4 in 4
		
		/*
		gen double `yh' = (1+`phi')/(tightDP*`rho'+(1-tightDP)*rate1*(1-margtax) + propertytax 	- growth + growth*(1-tightDP)*(1-mobility)*((`rho'-(1-margtax)*rate1)/(`rho'+mobility)))-WTP1 +1 in 1
			
        replace `yh' = (1+`phi')/(looseDP*`rho'+(1-looseDP)*rate1*(1-margtax)+propertytax- growth+growth*(1-looseDP)*(1-mobility)*((`rho'-(1-margtax)*rate1)/(`rho'+mobility)))-WTP2 in 2

        replace `yh' = (1+`phi')/(looseDP*`rho'+(1-looseDP)*rate2*(1-margtax)+propertytax		- growth+growth*(1-looseDP)*(1-mobility)*((`rho'-(1-margtax)*rate2)/(`rho'+mobility)))-WTP3 in 3
*/
        replace `varlist' = `yh'

 end
 
 *FInds the 2D heterogeneirty for the full FZ UC model
 
 capture program drop nlsolver_Q12
program nlsolver_Q12, rclass


		syntax varlist(min=1 max=1) [if], at(name)
		
		tempname	phi  rho
		scalar `phi' = `at'[1,1]
		scalar `rho' = `at'[1,2]
		
		tempvar yh
        	
		gen double `yh' = (1+`phi')/(tightDP*`rho'+(1-tightDP)*rate1*(1-margtax) + propertytax ///
		- growth + growth*(1-tightDP)*(1-mobility)*((`rho'-(1-margtax)*rate1)/(`rho'+mobility)))-WTP1 +1 in 1
			
        replace `yh' = (1+`phi')/(looseDP*`rho'+(1-looseDP)*rate1*(1-margtax)+propertytax ///
		- growth+growth*(1-looseDP)*(1-mobility)*((`rho'-(1-margtax)*rate1)/(`rho'+mobility)))-WTP2 in 2
        
        replace `varlist' = `yh'

 end
 
	
*Settting up parameters	
scalar rateHigh=0.065
scalar rateLow=0.045
scalar rate=0.5*(rateHigh+rateLow)
scalar tightDP=0.2
scalar looseDP=0.05
scalar margtax=0.34
scalar propertytax=0.0335
scalar mobility=0.06
scalar growth=0.02
scalar RPratio_full =1/(rate*(1-margtax)+propertytax - growth)
scalar RPratio_simp=(1/rate)
	
*settin gup solver RHS variables
capture drop y1
generate y1=0 if _n<2
replace y1 = 1 in 1

capture drop y2
generate y2=0 if _n<3
replace y2 = 1 in 1

capture drop y3
generate y3=0 if _n<4
replace y3 = 1 in 1

capture drop y4
generate y4=0 if _n<5
replace y4 = 1 in 1
	
* Setting up output series

foreach suffix in "Q12" "Q14" "Q124" "Q1"{
	capture drop phi_`suffix'
	capture drop rho_`suffix'
	gen phi_`suffix'=.
	gen rho_`suffix'=.
	
	capture drop iterations_`suffix'
	gen iterations_`suffix'=.
	capture drop converge_`suffix'
	gen converge_`suffix'=.
		
	}

	capture drop Rate1Check
	gen Rate1Check=.
	
*Solving loop
forvalues i= 1/`=_N' {
*   forvalues i= 1/50 {

   if startRateLow[`i']==1 {
   	scalar rate1=rateLow
	scalar rate2=rateHigh
   }

      if startRateLow[`i']==0 {
   	scalar rate1=rateHigh
	scalar rate2=rateLow
   }
   
	replace Rate1Check=rate1 if `i'==_n
   

	scalar WTP1=Q1relApp[`i']*RPratio_full
	scalar WTP2=Q2relApp[`i']*RPratio_full
	scalar WTP3=Q3relApp[`i']*RPratio_full
	scalar WTP4=Q4relApp[`i']*RPratio_full
	scalar phiQ4=phi_from_Q4[`i']


	capture qui nl solver_Q124 @ y2, parameters(rho) initial(rho .05)
	  
	*  scalar temp_phi= e(b)[1,1] 
	 * qui replace phi_simp= temp_phi if _n==`i'
	scalar temp_rho= e(b)[1,1] 
	qui  replace rho_Q124= temp_rho if _n==`i'
		
	qui replace converge_Q124=e(converged) if `i'==_n
	qui replace iterations_Q124= e(ic) if `i'==_n

	capture qui nl solver_Q12 @ y2, parameters(phi rho) initial(phi 0 rho .05)
	
	scalar temp_phi= r(table)[1,1] 
	qui replace phi_Q12= temp_phi if _n==`i'
	scalar temp_rho= r(table)[1,2] 
	qui  replace rho_Q12= temp_rho if _n==`i'
	qui replace converge_Q12=e(converged) if `i'==_n
	qui replace iterations_Q12= e(ic) if `i'==_n
	
	capture qui nl solver_Q14 @ y2, parameters(rho) initial(rho .05)
	scalar temp_rho= r(table)[1,1] 
	qui  replace rho_Q14= temp_rho if _n==`i'	
	qui replace converge_Q14=e(converged) if `i'==_n
	qui replace iterations_Q14= e(ic) if `i'==_n
	
	
	scalar phiQ4=0
	capture qui nl solver_Q14 @ y2, parameters(rho) initial(rho .05)
	scalar temp_rho= r(table)[1,1] 
	qui  replace rho_Q1= temp_rho if _n==`i'	
	qui replace converge_Q1=e(converged) if `i'==_n
	qui replace iterations_Q1= e(ic) if `i'==_n


	di "_n=" "`i'"
  
}

foreach suffix in "Q12" "Q14" "Q124" "Q1"{
	capture drop beta_`suffix'
	gen beta_`suffix'=1/(1+rho_`suffix')
		
	}

capture drop phi_Q14
capture drop phi_Q124
capture drop phi_Q1
gen phi_Q14=phi_from_Q4
gen phi_Q124=phi_from_Q4
gen phi_Q1=0
	